<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:ns="https://ezwm.nfz.gov.pl/xml/e-zpo/dok-wynik-weryfikacji/v2.1"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- wersja transformaty -->
	<xsl:variable name="wersja" select="'1.1.0'"/>
	<xsl:output encoding="UTF-8" indent="yes" 
	doctype-public="-//W3C//DTD HTML 4.01//EN" 
	media-type="text/html"/>
	<xsl:include href="common.xslt"/>
	<xsl:template match="/ns:dokument-zpo">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"></meta>
				<xsl:call-template name="StyleWspolne"/>
				<style>
					@page {
					    size: A3;
					    margin-top: 0.5cm;
					    margin-left: 0cm;
					    margin-right: 0cm;
					}
				</style>
			</head>
			
			<body>
				<xsl:choose>
					<xsl:when test="./@typ-dokumentu != 'E'">
						<xsl:call-template name="bladTypDokumentu" />
					</xsl:when>
					<xsl:when test="./@nr-druku != 'Z.2023.1' and ./@nr-druku != 'N.2023.1'">
						<xsl:call-template name="bladNrDruku" />
					</xsl:when>			
					<xsl:when test="./ns:zlecenie/ns:weryfikacja/@etap != 'Z'">
						<xsl:call-template name="bladEtapWeryfikacji" />
					</xsl:when>
					<xsl:when test="./@nr-druku = 'Z.2023.1'">
						<xsl:call-template name="header">
							<xsl:with-param name="zlecenie"
								select="./ns:zlecenie" />
						</xsl:call-template>
						<xsl:call-template name="weryfikacja-zlecenia">
							<xsl:with-param name="zlecenie" select="./ns:zlecenie" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="./@nr-druku = 'N.2023.1'">
						<xsl:call-template name="header">
							<xsl:with-param name="zlecenie"
								select="./ns:zlecenie" />
						</xsl:call-template>
						<xsl:call-template name="weryfikacja-naprawy">
							<xsl:with-param name="zlecenie" select="./ns:zlecenie" />
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>		
				<footer>
					<xsl:call-template name="footer">
						<xsl:with-param name="wersja" select="$wersja" />
					</xsl:call-template>
				</footer>
			</body>
			
		</html>
	</xsl:template>

	<xsl:template name="weryfikacja-zlecenia">
		<xsl:param name="zlecenie" />
		
		<div>			
			<div class="naglowek">
				<strong>CZĘŚĆ II. WERYFIKACJA ZLECENIA </strong>
				<span style="font-size: 15px">(DOKONYWANA PRZEZ NFZ ZA POŚREDNICTWEM USŁUG 
				INFORMATYCZNYCH NFZ ALBO BEZPOŚREDNIO W ODDZIALE WOJEWÓDZKIM NFZ 
				– WÓWCZAS DRUKUJE OSOBA UPRAWNIONA DO WYSTAWIENIA ZLECENIA)</span>
			</div>	
			<xsl:variable name="weryfikacja" select="$zlecenie/ns:weryfikacja" />
			<xsl:call-template name="wynik-weryf-zlecenie">
				<xsl:with-param name="weryfikacja" select="$weryfikacja" />
			</xsl:call-template>
			
			<xsl:call-template name="potw-limitu-zlecenie">
				<xsl:with-param name="weryfikacja" select="$weryfikacja" />
			</xsl:call-template>
			
			<xsl:call-template name="potw-prawa-do-swiad">
				<xsl:with-param name="potw-uprawnien" select="$weryfikacja/ns:potw-uprawnien" />
			</xsl:call-template>
			
			<xsl:call-template name="negatywna-weryf-zlecenie">
				<xsl:with-param name="neg-weryf" select="$weryfikacja/ns:wynik-negatywny" />
			</xsl:call-template>
			
			<xsl:call-template name="informacje-zlecenie">
				<xsl:with-param name="informacje" select="$weryfikacja/ns:dod-informacje" />
			</xsl:call-template>
			
			<xsl:call-template name="potw-weryf-zlecenie">
				<xsl:with-param name="weryfikacja" select="$weryfikacja" />
			</xsl:call-template>
		</div>
		<br/>

	</xsl:template>
	
	<xsl:template name="wynik-weryf-zlecenie">
		<xsl:param name="weryfikacja" />
	
		<div class="sekcja">
			<div>
				<strong>II.A. WYNIK WERYFIKACJI</strong>
			</div>
			<table class="rubryka" style="height: 60px;">
				<tr>
				
					<th class="opis-pola" style="width: 45%;">
						II.A.1 Wynik weryfikacji
						<sup>17)</sup>
					</th>
					<th class="opis-pola" style="width: 45%;">
						II.A.2 Kod oddziału wojewódzkiego NFZ
						<sup>18)</sup>
					</th>
				</tr>
				<tr>
					<td class="pole">
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="not($weryfikacja/ns:wynik-negatywny)">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>pozytywna</label>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$weryfikacja/ns:wynik-negatywny">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>negatywna</label>
					</td>
					<td class="pole">
						<xsl:variable name="ow-nfz"
							select="$weryfikacja/@ow-nfz" />
						<xsl:call-template name="translateOwCode">
							<xsl:with-param name="ow-nfz" select="$ow-nfz" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
	
			<xsl:variable name="wynik-pozytywny"
				select="$weryfikacja/ns:wynik-pozytywny" />
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th style="width: 45%;">
						II.AA.1 Realizacja zlecenia od dnia
					</th>
					<th style="width: 45%;">
						II.AA.2 Końcowa data realizacji zlecenia
					</th>
				</tr>
				<tr>
					<td>
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$wynik-pozytywny/@realizacja-od" />
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$wynik-pozytywny/@data-wazn-zlec" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>

	<xsl:template name="potw-limitu-zlecenie">
		<xsl:param name="weryfikacja" />

		<div class="sekcja">
			<div>
				<strong>II.B. POTWIERDZENIE LIMITU FINANSOWANIA ZE ŚRODKÓW
					PUBLICZNYCH WYROBU MEDYCZNEGO</strong>
			</div>
			<table class="tabela">
				<tr style="height: 40px;">
					<th style="width: 15%;">
						II.B.1 Grupa i liczba porządkowa
					</th>
					<th tyle="width: 15%;">
						II.B.2 Kod wyrobu medycznego
					</th>
					<th style="width: 15%;">
						II.B.3 Umiejscowienie
						<br />
						(L - lewostronne,
						<br />
						P - prawostronne), jeżeli dotyczy
					</th>
					<th style="width: 15%;">
						II.B.4 Potwierdzona liczba sztuk
					</th>
					<th style="width: 15%;">
						II.B.5 Limit finansowania
						<sup>19)</sup>
					</th>
					<th style="width: 15%;">
						II.B.6 Wysokość procentowego udziału NFZ w limicie finansowania
						<sup>20)</sup>
					</th>
					<th style="width: 15%;">
						II.B.7 Data ważności potwierdzenia limitu finansowania
						<sup>21)</sup>
					</th>
				</tr>

				<xsl:for-each
					select="$weryfikacja/ns:wynik-pozytywny/ns:potw-wyrob-med">
					<tr style="height: 60px;">
						<td>
							<xsl:value-of select="./@kod-mz" />
						</td>
						<td>
							<xsl:value-of select="./@kod-przedm" />
						</td>
						<td>
							<xsl:value-of select="./@umiejsc" />
						</td>
						<td>
							<xsl:value-of select="./@liczba-szt" />
						</td>
						<td>
							<xsl:value-of select="./@limit-ceny" />
						</td>
						<td>
							<xsl:value-of select="./@refundacja" />
						</td>
						<td>
							<xsl:call-template name="dateFormat">
								<xsl:with-param name="data"
									select="./@data-waznosci" />
							</xsl:call-template>
						</td>
					</tr>
				</xsl:for-each>
				<xsl:if
					test="not($weryfikacja/ns:wynik-pozytywny/ns:potw-wyrob-med)">
					<tr style="height: 75px;">
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
				</xsl:if>
			</table>
		</div>

	</xsl:template>
	
	<xsl:template name="potw-prawa-do-swiad">
		<xsl:param name="potw-uprawnien" />
	
		<div class="sekcja">
			<div>
				<strong>II.BA. POTWIERDZONE PRAWO DO ŚWIADCZEŃ OPIEKI ZDROWOTNEJ</strong>
			</div>
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th class="opis-pola" style="width: 45%;">
						II.BA.1 Sposób potwierdzenia prawa do świadczeń
						<sup>22)</sup>
					</th>
					<th class="opis-pola" style="width: 45%;">
						II.BA.2 Dane identyfikujące dokument potwierdzający prawo do świadczeń, 
						jeżeli w pkt II.BA.1 zaznaczono „dokument”
						<sup>23)</sup>
					</th>
				</tr>
				<tr>
					<td class="pole">
						<xsl:variable name="sposob-potw-uprawnien" select="$potw-uprawnien/@sposob-potw-uprawnien" />
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="($sposob-potw-uprawnien = 'E') or ($potw-uprawnien and not($sposob-potw-uprawnien))">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>eWUŚ</label>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$sposob-potw-uprawnien = 'O'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>oświadczenie</label>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$sposob-potw-uprawnien = 'D'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>dokument</label>
					</td>
					<td class="pole">
						<xsl:variable name="dokument"
							select="$potw-uprawnien/ns:dokument" />
						<xsl:value-of select="$dokument/@rodzaj" />
						<xsl:if test="$dokument/@rodzaj">
							<xsl:call-template name="potwPrawaDokumentRodzaj">
								<xsl:with-param name="kodDok"
									select="$dokument/@rodzaj" />
							</xsl:call-template>
						</xsl:if>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$dokument/@numer" />
						<xsl:text> </xsl:text>
						<xsl:value-of select="$dokument/@nazwa" />
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
	<xsl:template name="negatywna-weryf-zlecenie">
		<xsl:param name="neg-weryf" />
	
		<div class="sekcja">
			<div>
				<strong>II.C. PRZYCZYNA NEGATYWNEJ WERYFIKACJI </strong>
				(JEŻELI DOTYCZY)
			</div>
			<table class="tabela">
				<tr style="height: 250px;">
					<td class="left top">
						<xsl:variable name="problemy"
							select="$neg-weryf/ns:problem[not(@ocena-ow = 'P')]" />
						<xsl:for-each select="$problemy">
							<p>
								<xsl:value-of select="position()" />
								<xsl:text>. </xsl:text>
								<xsl:value-of select="./@kod-problemu-zlecenia" />
								<xsl:text> - </xsl:text>
								<xsl:value-of select="./@opis" />
							</p>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
	<xsl:template name="informacje-zlecenie">
		<xsl:param name="informacje" />
	
		<div class="sekcja">
			<div>
				<strong>II.D. DODATKOWE INFORMACJE DLA PACJENTA</strong>
			</div>
			<table class="rubryka">
				<tr class="left" align="left"
					style="font-size: 16px; vertical-align: top; height: 250px; table-layout: fixed;">
					<td class="left" align="left" style="vertical-align: top;">
						<xsl:variable name="informacje2"
							select="$informacje[@adresat = 'P']" />
						<xsl:for-each select="$informacje2">
							<xsl:text> </xsl:text>
							<xsl:value-of select="position()" />
							<xsl:text>. </xsl:text>
							<xsl:value-of select="./@opis" />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
	<xsl:template name="potw-weryf-zlecenie">
		<xsl:param name="weryfikacja" />
	
		<div class="sekcja">
			<div>
				<strong>II.E. POTWIERDZENIE WERYFIKACJI ZLECENIA</strong>
			</div>
			<table class="rubryka" style="height: 60px">
				<tr>
					<th style="width: 90%;">
						II.E.1 Data weryfikacji
					</th>
				</tr>
				<tr>
					<td class="left">
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$weryfikacja/@data-weryfikacji" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>

</xsl:template>
	
	
	<xsl:template name="weryfikacja-naprawy">
		<xsl:param name="zlecenie" />
		
		<div>
			<div class="naglowek" style="height: 40px;">
				<strong>CZĘŚĆ II. WERYFIKACJA ZLECENIA NAPRAWY</strong>
				<span style="font-size: 15px">(WYPEŁNIA I DRUKUJE ODDZIAŁ WOJEWÓDZKI NFZ)</span>
			</div>
		
			<xsl:variable name="weryfikacja" select="$zlecenie/ns:weryfikacja" />
			
			<xsl:call-template name="wynik-weryf-naprawa">
				<xsl:with-param name="weryfikacja" select="$weryfikacja" />
			</xsl:call-template>
		
			<xsl:call-template name="limit-finansowania-naprawa">
				<xsl:with-param name="dane-naprawy" select="$weryfikacja/ns:wynik-pozytywny/ns:dane-naprawy" />
			</xsl:call-template>
			
			<xsl:call-template name="potw-prawa-do-swiad-naprawa">
				<xsl:with-param name="potw-uprawnien" select="$weryfikacja/ns:potw-uprawnien" />
			</xsl:call-template>
			
			<xsl:call-template name="negatywna-weryf-naprawa">
				<xsl:with-param name="neg-weryf" select="$weryfikacja/ns:wynik-negatywny" />
			</xsl:call-template>
			
			<xsl:call-template name="informacje-naprawa">
				<xsl:with-param name="informacje" select="$weryfikacja/ns:dod-informacje" />
			</xsl:call-template>
			
			<xsl:call-template name="potw-weryf-naprawa">
				<xsl:with-param name="weryfikacja" select="$weryfikacja" />
			</xsl:call-template>		
		</div>
		<br/>
		
	</xsl:template>
	
	<xsl:template name="wynik-weryf-naprawa">
		<xsl:param name="weryfikacja" />
	
		<div class="sekcja">
			<div>
				<strong>II.A. WYNIK WERYFIKACJI</strong>
			</div>
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th class="opis-pola" style="width: 45%;">
						II.A.1 Wynik weryfikacji
						<sup>8)</sup>
					</th>
					<th class="opis-pola" style="width: 45%;">
						II.A.2 Kod oddziału wojewódzkiego NFZ
						<sup>9)</sup>
					</th>
				</tr>
				<tr>
					<td class="pole">
						<input type="checkbox" style="font-size: 14px;" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="not($weryfikacja/ns:wynik-negatywny)">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>pozytywna</label>
						<input type="checkbox" style="font-size: 14px;" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$weryfikacja/ns:wynik-negatywny">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>negatywna</label>
					</td>
					<td class="pole">
						<xsl:variable name="ow-nfz"
							select="$weryfikacja/@ow-nfz" />
						<xsl:call-template name="translateOwCode">
							<xsl:with-param name="ow-nfz" select="$ow-nfz" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
	
			<xsl:variable name="wynik-pozytywny"
				select="$weryfikacja/wynik-pozytywny" />
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th style="width: 45%;">
						II.AA.1 Realizacja zlecenia od dnia
					</th>
					<th style="width: 45%;">
						II.AA.2 Końcowa data realizacji zlecenia
					</th>
				</tr>
				<tr>
					<td>
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$wynik-pozytywny/@realizacja-od" />
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$wynik-pozytywny/@data-wazn-zlec" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
	<xsl:template name="limit-finansowania-naprawa">
		<xsl:param name="dane-naprawy" />

		<div class="sekcja">
			<div>
				<strong>II.B. POTWIERDZENIE LIMITU FINANSOWANIA ZE ŚRODKÓW PUBLICZNYCH NAPRAWY WYROBU MEDYCZNEGO
				</strong>
			</div>
			
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th style="width: 45%;">
						II.B.1 Limit ceny naprawy
					</th>
					<th style="width: 45%;">
						II.B.2 Kod naprawy wyrobu medycznego
					</th>
				</tr>
				<tr style="height: 40px;">
					<td>
						<xsl:call-template name="numberFormat">
							<xsl:with-param name="number"
								select="$dane-naprawy/@limit-naprawy" />
						</xsl:call-template>
					</td>
					<td>
						<xsl:value-of select="$dane-naprawy/@kod-naprawy" />
					</td>
				</tr>
				<tr>
					<th colspan="2">
						II.B.3 Okres użytkowania wyrobu medycznego ulega wydłużeniu do
					</th>
				</tr>
				<tr style="height: 40px;">
					<td colspan="2" class="left">
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$dane-naprawy/@okres-uzytkowania-wyr-med-ulega-wydl-do" />
						</xsl:call-template>
					</td>
				</tr>
			</table>	
		</div>
	</xsl:template>
	
	<xsl:template name="potw-prawa-do-swiad-naprawa">
		<xsl:param name="potw-uprawnien" />
		<div class="sekcja">
			<div>
				<strong>II.C. POTWIERDZONE PRAWO DO ŚWIADCZEŃ OPIEKI ZDROWOTNEJ</strong>
			</div>
			<table class="rubryka" style="height: 60px;">
				<tr>
					<th class="opis-pola" style="width: 45%;">
						II.C.1 Sposób potwierdzenia prawa do świadczeń
						<sup>10)</sup>
					</th>
					<th class="opis-pola" style="width: 45%;">
						II.C.2 Dane identyfikujące dokument potwierdzający prawo do świadczeń, 
						jeżeli w pkt II.C.1 zaznaczono „dokument”
						<sup>11)</sup>
					</th>
				</tr>
				<tr>
					<td class="pole">
						<xsl:variable name="sposob-potw-uprawnien" select="$potw-uprawnien/@sposob-potw-uprawnien" />
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="($sposob-potw-uprawnien = 'E') or ($potw-uprawnien and not($sposob-potw-uprawnien))">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>eWUŚ</label>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$sposob-potw-uprawnien = 'D'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
						</input>
						<label>dokument</label>
					</td>
					<td class="pole">
						<xsl:variable name="dokument"
							select="$potw-uprawnien/ns:dokument" />
						<xsl:value-of select="$dokument/@rodzaj" />
						<xsl:if test="$dokument/@rodzaj">
							<xsl:call-template name="potwPrawaDokumentRodzaj">
								<xsl:with-param name="kodDok"
									select="$dokument/@rodzaj" />
							</xsl:call-template>
						</xsl:if>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$dokument/@numer" />
						<xsl:text> </xsl:text>
						<xsl:value-of select="$dokument/@nazwa" />
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
	
	<xsl:template name="negatywna-weryf-naprawa">
		<xsl:param name="neg-weryf" />
	
		<div class="sekcja">
			<div>
				<strong>II.D. PRZYCZYNA NEGATYWNEJ WERYFIKACJI
				</strong>(JEŻELI DOTYCZY)
			</div>
	
			<table class="tabela">
				<tr style="height: 250px;">
					<td class="left top">
						<xsl:variable name="problemy"
							select="$neg-weryf/ns:problem[not(@ocena-ow = 'P')]" />
						<xsl:for-each select="$problemy">
							<p>
								<xsl:value-of select="position()" />
								<xsl:text>. </xsl:text>
								<xsl:value-of select="./@kod-problemu-zlecenia" />
								<xsl:text> - </xsl:text>
								<xsl:value-of select="./@opis" />
							</p>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template name="informacje-naprawa">
		<xsl:param name="informacje" />
	
		<div class="sekcja">
			<div><strong>II.E. DODATKOWE INFORMACJE DLA PACJENTA</strong></div>
		
			<table class="rubryka">
				<tr class="left" align="left"
					style="font-size: 16px; vertical-align: top; height: 250px; table-layout: fixed;">
					<td class="left" align="left" style="vertical-align: top;">
						<xsl:variable name="informacje2"
							select="$informacje[@adresat = 'P']" />
						<xsl:for-each select="$informacje2">
							<xsl:text> </xsl:text>
							<xsl:value-of select="position()" />
							<xsl:text>. </xsl:text>
							<xsl:value-of select="./@opis" />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
	<xsl:template name="bladEtapWeryfikacji">
		<div class="blad">
			BŁĄD: NIEPOPRAWNA WARTOŚĆ ETAPU WERYFIKACJI DLA DOKUMENTU W WERSJI ELEKTRONICZNEJ
		</div>
	</xsl:template>
	
	<xsl:template name="potw-weryf-naprawa">
		<xsl:param name="weryfikacja" />
	
		<div class="sekcja">
			<div>
				<strong>II.F. POTWIERDZENIE WERYFIKACJI ZLECENIA</strong>
			</div>
	
			<table class="rubryka">
				<tr>
					<th style="width: 90%;">
						II.F.1 Data weryfikacji
					</th>
				</tr>
				<tr style="height: 40px;">
					<td class="left">
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$weryfikacja/@data-weryfikacji" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
	
	</xsl:template>
	
</xsl:stylesheet>
